unit GridEditor01;

interface
uses SysUtils, Dialogs, Grids;

//    
//     0  1
const ArrMinNum   = 0; //    
      ArrMaxNumD1 = 4; //     
      ArrMaxNumD2 = 4; //     

//   ,     
type T2DIntegerArray = array[ArrMinNum..ArrMaxNumD1,
                             ArrMinNum..ArrMaxNumD2]
                       of integer;

//       
function TextToInt (Text : string; var Digit : integer): boolean;


//      
procedure InitStringGridFor2DIntArray (RqArr  : T2DIntegerArray;
                                       RqGrid : TStringGrid;
                                       RqFix  : boolean);

//    StringGrid
procedure Load2dIntArrToStringGrid (RqArr  : T2DIntegerArray;
                                    RqGrid : TStringGrid);


//   GRID    T2DIntegerArray
procedure EditInGrid2DIntegerArray(Sender      : TObject;
                                   ACol, ARow  : Integer;
                                   const Value : String;
                                   var RqArr   : T2DIntegerArray);

implementation

//-------------------------------------------------------------------------
// 26.10.2008
//       
function TextToInt (Text : string; var Digit : integer): boolean;
begin
  try
    Digit := StrToInt(Text);
    TextToInt := True;
  except
    Digit := 0;
    TextToInt := False;
  end;
end; // of function


//      
procedure InitStringGridFor2DIntArray (RqArr  : T2DIntegerArray;
                                       RqGrid : TStringGrid;
                                       RqFix  : boolean);

var LowArrD1 : integer;   //    
    LowArrD2 : integer;   //    
    Ind1     : integer;   //   StringGrid
    Ind2     : integer;   //   
begin
   //     
   LowArrD1 := Low(RqArr);
   LowArrD2 := Low(RqArr[LowArrD1]);
   //  
   //   
   RqGrid.Options := RqGrid.Options + [goEditing];
   if RqFix then begin
     //        
     RqGrid.FixedRows := 1;
     RqGrid.RowCount := Length(RqArr) + 1;
     RqGrid.FixedCols := 1;
     RqGrid.ColCount := Length(RqArr[LowArrD1])+ 1;
     //   
     Ind2 := LowArrD1;
     for Ind1 := 1 to (RqGrid.RowCount - 1)
     do begin
       RqGrid.Cells[0,Ind1] := IntToStr(Ind2);
       Ind2 := Ind2 + 1;
     end;
     //   
     Ind2 := LowArrD2;
     for Ind1 := 1 to (RqGrid.ColCount - 1)
     do begin
       RqGrid.Cells[Ind1,0] := IntToStr(Ind2);
       Ind2 := Ind2 + 1;
     end;
     //   
     RqGrid.Cells[0,0]:= 'R\C'
   end
   else begin
     //       
     RqGrid.FixedRows := 0;
     RqGrid.RowCount := Length(RqArr);
     RqGrid.FixedCols := 0;
     RqGrid.ColCount := Length(RqArr[LowArrD1]);
   end;
   //    StringGrid
   Load2dIntArrToStringGrid (RqArr, RqGrid);

end;

//    StringGrid
procedure Load2dIntArrToStringGrid (RqArr  : T2DIntegerArray;
                                    RqGrid : TStringGrid);
var ArrRow   : integer;   //   
    ArrCol   : integer;   //   
    Row      : integer;   //   StringGrid
    Col      : integer;   //   StringGrid
begin
   for ArrRow := Low(RqArr) to High(RqArr)
   do begin
     for ArrCol := Low(RqArr[ArrRow]) to High(RqArr[ArrRow])
     do begin
       //   StringGrid
       Row := ArrRow - Low(RqArr) + RqGrid.FixedRows;
       Col := ArrCol - Low(RqArr[ArrRow]) + RqGrid.FixedCols;
       if RqArr[ArrRow,ArrCol] <> 0
       then RqGrid.Cells[Col,Row]:= IntToStr(RqArr[ArrRow,ArrCol])
       else RqGrid.Cells[Col,Row]:= '';
     end;
   end;
end;


//-----------------------------------------------------------
// 17.10.2009
//    OnSetEditText   TStringGrid
//   GRID    T2DIntegerArray
procedure EditInGrid2DIntegerArray(Sender      : TObject;
                                   ACol, ARow  : Integer;
                                   const Value : String;
                                   var RqArr   : T2DIntegerArray);
var ArrRow   : integer;   //   
    ArrCol   : integer;   //   
    WD : integer;
begin
   //    Grid
   if Sender is TStringGrid
   then begin
     with TStringGrid(Sender) do
     begin
        //    c    
        ArrRow := ARow - FixedRows + Low(RqArr);
        ArrCol := ACol - FixedCols + Low(RqArr[Low(RqArr)]);
        //---------------------------------
        if Cells[ACol, ARow] <> '-'
        //     
        then begin
          if Cells[ACol, ARow] <> ''
          //    (  )
          then begin
             //     
             if TextToInt (Cells[ACol, ARow], WD)
             then begin
               //     
               //     RqArray
               RqArr[ArrRow, ArrCol]:= WD;
             end
             else begin
               MessageDlg( ' : : ' + Value
                     + #13#10 + '    .'
                     + #13#10 + ' :   .',
                     mtWarning, [mbOk], 0);
               //   
               if RqArr[ArrRow, ArrCol] = 0
               then Cells[ACol, ARow] := ''
               else Cells[ACol, ARow] := IntToStr(RqArr[ArrRow, ArrCol]);
             end;
          end
          else begin
            //    
            RqArr[ArrRow, ArrCol] := 0;
          end;  {of if Value <> '' }
        end
        else begin
          //     
          RqArr[ArrRow, ArrCol] := 0;
        end;  // of if Value <> '-'
     end; // of with TStringGrid(Sender)
   end;   // of if Sender is TStringGrid
end; // of procedure

end.
